//
//  MCSimpleServerEndpoint.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 17/07/09.
//  Copyright 2009 Marketcircle Inc. All rights reserved.
//

#import <MCNetComm/MCFileTransferEndpoint.h>

/*
 
 MCSimpleServerEndpoint is an(other!) abstract endpoint class which adds support for simple, dynamic, one-at-a-time socket server. It automatically
 advertises itself on Bonjour when it starts. When a client connects, it stops accepting new connections and stops publishing its advertisement. When
 the client disconnects, it resumes listening and republishes its Bonjour advertisement.
 
 -waitForConnection and -stopWaitingForConnection are called automatically; subclasses  do not need to do this  (and will cause errors if they try
 to do so at the wrong time).
 
 Future ideas:
 - Add a boolean property for whether or not to advertise on Bonjour, and whether to disable advertisements while connected.
 - Ask the delegate whether to wait and/or stop waiting
 - Add support for SSL
 
 */


@class MCSocketIOChannel;

#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
@interface MCSimpleServerEndpoint : MCFileTransferEndpoint
#else
@interface MCSimpleServerEndpoint : MCFileTransferEndpoint <NSNetServiceDelegate>
#endif
{

	id delegate; // weak
	MCSocketIOChannel *listenChannel;
	NSString *serviceName;
	NSString *serviceType;
	NSNetService *service;
	NSDictionary *TXTEntries;
	
	BOOL discreteMode;
}

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (MCSocketIOChannel *)listenChannel;
- (void)setListenChannel:(MCSocketIOChannel *)newChannel;

- (NSString *)serviceName;
- (void)setServiceName:(NSString *)newServiceName;
- (NSString *)serviceType;
- (void)setServiceType:(NSString *)newServiceType;
- (NSDictionary *)TXTEntries;
- (void)setTXTEntries:(NSDictionary *)newTXTEntries;

- (NSNetService *)service;
- (void)setService:(NSNetService *)newService;

- (BOOL)discreteMode;
- (void)setDiscreteMode:(BOOL)flag;

- (UInt16)listeningPort;

- (void)registerService;
- (BOOL)waitForConnection:(NSError **)error_p;
- (void)stopWaitingForConnection;

@end

@interface NSObject (MCSimpleServerDelegate)

- (BOOL)mcSimpleServer:(MCSimpleServerEndpoint *)server gotError:(NSError *)error;

@end

